<#ibiztemplate>
TARGET=PSDEDBTABLE
</#ibiztemplate>
package ${pub.getPKGCodeName()}.mybatis.${de.getPSSystemModule().getCodeName()?lower_case};

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;

import ${pub.getPKGCodeName()}.core.repository.${de.getCodeName()}Repository;
<#if de.getPSDERInherit()??>
  <#if de.getPSDERInherit().getMajorPSDataEntity()??>
import ${pub.getPKGCodeName()}.core.repository.${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()}Repository;
  </#if>
</#if>
import ${pub.getPKGCodeName()}.core.repository.po.${de.getCodeName()};
import ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.filter.${de.codeName}SearchContext;
import ${pub.getPKGCodeName()}.mybatis.${de.getPSSystemModule().getCodeName()?lower_case}.mapper.${item.name}Mapper;
import ${pub.getPKGCodeName()}.mybatis.${de.getPSSystemModule().getCodeName()?lower_case}.po.${item.name}Impl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import ${pub.getPKGCodeName()}.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[${item.name}]存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "${de.getCodeName()?lower_case}", value="store" , havingValue = "sql", matchIfMissing = <#if de.getStorageMode()==1>true<#else>false</#if>)
public class ${item.name}RepositoryImpl extends ServiceImpl<${item.name}Mapper, ${item.name}Impl> implements ${de.getCodeName()}Repository {

    <#if de.getPSDERInherit()??>
      <#if de.getPSDERInherit().getMajorPSDataEntity()??>
    @Autowired  
    ${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()}Repository ${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()?uncap_first}Repository ;
      </#if>
    </#if>
    
    /**
     * mybatis条件构造器
     */
    @Autowired
    QueryBuilder queryBuilder;
    /**
     * [${item.name}]持久层映射对象
     */
    @Autowired
	${item.name}Mapper ${item.name?uncap_first}Mapper;

    /**
     * 创建持久层对象
     * @return
     */
    public ${de.getCodeName()} createPO(){
        return new ${item.name}Impl();
    }

    /**
     * 获取数据
     * @param key 业务数据主键
     * @return
     */
    public ${de.getCodeName()} get(String key){
        return this.getById(key);
    }

    <#--private boolean isLogicValid = ${de.isLogicValid()?c} ;-->
    <#--  public ${item.name} get(${item.name} po){
        ${item.name} result = this.get(po.get${de.getKeyPSDEField().getCodeName()?lower_case?cap_first}());
        if(result!=null){
		    BeanCopier copier=BeanCopier.create(result.getClass(),po.getClass(), false);
		    copier.copy(result,po,null);
    	}
    	return po;
    }  -->
    /**
     * 新建数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean create(${de.getCodeName()} po){
        boolean bOk = this.save((${item.name}Impl)po);
        <#if de.getPSDERInherit()??>
          <#if de.getPSDERInherit().getMajorPSDataEntity()??>
        ${pub.getPKGCodeName()}.core.repository.po.${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()} ${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()?uncap_first} = convert2Inherit(po) ;
        ${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()?uncap_first}Repository.create(${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()?uncap_first}) ;  
          </#if>
        </#if>
        return bOk;
    }

    /**
     * 更新数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean update(${de.getCodeName()} po){
        boolean bOk = this.updateById((${item.name}Impl)po);
        <#if de.getPSDERInherit()??>
          <#if de.getPSDERInherit().getMajorPSDataEntity()??>
        ${pub.getPKGCodeName()}.core.repository.po.${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()} ${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()?uncap_first} = convert2Inherit(po) ;
        ${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()?uncap_first}Repository.update(${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()?uncap_first}) ;  
          </#if>
        </#if>
        return bOk;
    }

    /**
     * 删除数据
     * @param key 业务数据主键
     * @return
     */
    public boolean remove(String key){
        <#if de.getPSDERInherit()??>
          <#if de.getPSDERInherit().getMajorPSDataEntity()??>
        ${de.getPSDERInherit().getMajorPSDataEntity().getCodeName()?uncap_first}Repository.remove(key) ;  
          </#if>
        </#if>
        return this.removeById(key);
    }

<#if de.getAllPSDEDataSets()??>
    <#list de.getAllPSDEDataSets() as dedataset>
    /**
     * 查询集合[${dedataset.getCodeName()}]
     * @param context 查询上下文对象
     * @return
     */
    public Page<${de.getCodeName()}> search${dedataset.getCodeName()?cap_first}(${de.codeName}SearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<${de.getCodeName()}> page_datas=${item.name?uncap_first}Mapper.search${dedataset.getCodeName()?cap_first}(page,context,qw);
        List<${de.getCodeName()}> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<${de.getCodeName()}>(list_datas, context.getPageable(), page_datas.getTotal());
    }

    </#list>
</#if>
    <#if de.getPSDERInherit()??>
      <#if de.getPSDERInherit().getMajorPSDataEntity()??>
        <#assign parentDE = de.getPSDERInherit().getMajorPSDataEntity()>
        <#assign indexKeyField = parentDE.getIndexTypePSDEField()>
        <#assign parentDEKeyField = parentDE.getKeyPSDEField()>
        <#assign parentDENameField = parentDE.getPSDEField(parentDE.getName()+"NAME") > 
        <#assign childDEKeyField = de.getKeyPSDEField()>
        <#assign childDENameField = de.getPSDEField(de.getName()+"NAME") > 
    /**
     * 转业务继承主对象
     * @param po 持久层对象
     * @return
     */
    public ${pub.getPKGCodeName()}.core.repository.po.${parentDE.getCodeName()} convert2Inherit(${de.getCodeName()} po){
        if(po == null)
            return null ;
        ${pub.getPKGCodeName()}.core.repository.po.${parentDE.getCodeName()} ${parentDE.getCodeName()?uncap_first} = ${parentDE.getCodeName()?uncap_first}Repository.createPO() ;
        ${parentDE.getCodeName()?uncap_first}.set${indexKeyField.getCodeName()?cap_first}("${de.getPSDERInherit().getTypeValue()}") ;
        ${parentDE.getCodeName()?uncap_first}.set${parentDEKeyField.getCodeName()?cap_first}(po.get${childDEKeyField.getCodeName()?cap_first}()) ;
        ${parentDE.getCodeName()?uncap_first}.set${parentDENameField.getCodeName()?cap_first}(po.get${childDENameField.getCodeName()?cap_first}()) ;
        <#list parentDE.getAllPSDEFields()  as defield>
        <#if (defield.getName() != parentDEKeyField.getName()) && (defield.getName() != parentDENameField.getName())&& (defield.getName() != indexKeyField.getName())>
        if(po.get${defield.getCodeName()?cap_first}DirtyFlag())
            ${parentDE.getCodeName()?uncap_first}.set${defield.getCodeName()?cap_first}(po.get${defield.getCodeName()?cap_first}());
        </#if>
        </#list>
        return ${parentDE.getCodeName()?uncap_first} ;
    }

      </#if>
    </#if>
    /**
     * 持久层对象转业务对象
     * @param po 持久层对象
     * @param domain 业务对象
     * @return
     */
    public ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.domain.${de.getCodeName()} convert2Domain( ${de.getCodeName()} po ,${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.domain.${de.getCodeName()} domain){
        if(po == null)
            return domain ;
        if(domain == null){
            domain = new ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.domain.${de.getCodeName()}();
        }
    <#list de.getAllPSDEFields()  as defield>
        //if(po.get${defield.getCodeName()?cap_first}DirtyFlag())
        domain.set${defield.getCodeName()?cap_first}(po.get${defield.getCodeName()?cap_first}());
    </#list>
        return domain ;
    }

    /**
     * 业务对象转持久层对象
     * @param domain 业务对象
     * @param po 持久层对象
     * @return
     */
    public ${de.getCodeName()} convert2PO(${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.domain.${de.getCodeName()} domain , ${de.getCodeName()} po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
    <#list de.getAllPSDEFields()  as defield>
        if(domain.get${defield.getCodeName()?cap_first}DirtyFlag())
            po.set${defield.getCodeName()?cap_first}(domain.get${defield.getCodeName()?cap_first}());
    </#list>

        return po ;
    }
}
